define(['angular', 'app', 'patient'], function (angular, app) {
	'use strict';
	app.service('RemindersService', function ($filter, CollectionCRUDService, localResourceDirectoryService, formatter) {
		var RemindersService = function(extension){

			var config = {},
				frequencyEnum = {
					once : 1,
					daily : 2,
					weekly : 3,
					monthly : 4
				};

			config.dependency = { 
				service : localResourceDirectoryService
			};

			config.object = {
				uidKey : '_id',
				requestTransform : function(item) {
					var dateifiedEventDate = new Date(item.eventDate);

					item.enabledFlag = item.notificationStatus === 'On';
					item.daysInWeek = [dateifiedEventDate.toString().substr(0, 3)];
					item.daysInMonth = [dateifiedEventDate.getDate()];

					if (item.frequency !== null && item.frequency !== 'Daily') {
						item.times = item.times.slice(0, 1);
					}

					if (item.notificationTypes) {
						item.notificationTypes = $filter('filter')(item.notificationTypes, function (value, i) { return !!value; });
					}

					if (item.alert) {
						item.alert = $filter('filter')(item.alert, function (value, i) { return !!value; });
					}

					if (item.times !== null) {
						item.times = formatter.undotifyArrayOfPrimatives(item.times)
					}

					return item;
				},
				responseTransform : function(item) {
					item.notificationStatus = item.enabledFlag ? 'On' : 'Off';
					if (item.times && item.times.length > 0) {
						item.times = formatter.dotifyArrayOfPrimatives(item.times);
					} else {
						item.times = [];
					}
					item.frequencySortKey = frequencyEnum.frequency;
					if (item.notificationTypes && item.notificationTypes.length > 0) {
						var notificationTypes = ['In-App', 'Email'];
						var notifTypeLen = notificationTypes.length;
						for (var i = 0; i < notifTypeLen; i++) {
							if (item.notificationTypes.indexOf(notificationTypes[i]) === -1) {
								notificationTypes[i] = false;
							}
						}
						item.notificationTypes = notificationTypes
					} else {
						item.notificationTypes = [];
					}
					item.alert = item.alert || [];
					return item;
				}
			};

			config.collection = {
				name : 'reminders',
				objectType : 'Reminders',
				sortComparator : [{key: 'title'}, {key: 'frequencySortKey'}, {key: 	'enabledFlag', reverse: true}],
				filter : function(list, currentFilters) {
					if (currentFilters && currentFilters.status === 'All') {
						return list;
					} else {
						return list.filter(function(item){
							return currentFilters && (currentFilters.status === item.notificationStatus);
						});
					}
				}
			};

			angular.element.extend(true, config, extension);

			CollectionCRUDService.call(this, config);

			this.createEmpty = function(){
				var empty = {
					title : '',
					reminderClass : '',
					frequency : '',
					alert : [],
					enabledFlag : false,
					notes : '',
					type : 'In-App',
					source : 'VA FitHeart - Reminders',
					eventDate : '',
					times : [''],
					notificationTypes : ['In-App'],
					daysInWeek : [''],
					daysInMonth : [''],
					auxData : [{ 'key': 'source', 'value': 'HEART' }]
				};
				return this.config.object.responseTransform(angular.extend(empty, angular.copy(extension.object.defaults)));
			};
		};

		RemindersService.prototype = Object.create(CollectionCRUDService.prototype);
		RemindersService.prototype.constructor = RemindersService;

		return RemindersService;
	});
});